/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.image.modifier;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.client.image.CensoredImage;
import io.github.mortuusars.exposure.client.image.CroppedImage;
import io.github.mortuusars.exposure.client.image.Image;
import io.github.mortuusars.exposure.client.image.ResizedImage;
import io.github.mortuusars.exposure.client.image.modifier.pixel.AgedHSBModifier;
import io.github.mortuusars.exposure.client.image.modifier.pixel.BlackAndWhiteModifier;
import io.github.mortuusars.exposure.client.image.modifier.pixel.BrightnessModifier;
import io.github.mortuusars.exposure.client.image.modifier.pixel.ContrastModifier;
import io.github.mortuusars.exposure.client.image.modifier.pixel.NegativeFilmModifier;
import io.github.mortuusars.exposure.client.image.modifier.pixel.NegativeModifier;
import io.github.mortuusars.exposure.util.Rect2i;
import io.github.mortuusars.exposure.world.camera.ColorChannel;
import io.github.mortuusars.exposure.world.camera.component.ShutterSpeed;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public interface ImageModifier {
    public static final ImageModifier EMPTY = new Instance("", Function.identity());
    public static final ImageModifier CENSORED = new Instance("censored", CensoredImage::new);
    public static final ImageModifier NEGATIVE = new NegativeModifier();
    public static final ImageModifier NEGATIVE_FILM = new NegativeFilmModifier();
    public static final ImageModifier AGED = new AgedHSBModifier(14264419, 0.65f, 40, 255);
    public static final ImageModifier BLACK_AND_WHITE = new BlackAndWhiteModifier(0.299f, 0.587f, 0.114f);

    public String getIdentifier();

    public Image modify(Image var1);

    public static ImageModifier brightness(ShutterSpeed shutterSpeed) {
        return shutterSpeed != ShutterSpeed.DEFAULT ? new BrightnessModifier(shutterSpeed) : EMPTY;
    }

    public static ImageModifier singleChannelBlackAndWhite(ColorChannel colorChannel) {
        return switch (colorChannel) {
            default -> throw new MatchException(null, null);
            case ColorChannel.RED -> new BlackAndWhiteModifier(1.0f, 0.05f, 0.05f);
            case ColorChannel.GREEN -> new BlackAndWhiteModifier(0.05f, 1.0f, 0.05f);
            case ColorChannel.BLUE -> new BlackAndWhiteModifier(0.05f, 0.05f, 1.0f);
        };
    }

    public static ImageModifier contrast(float value) {
        return new ContrastModifier(value);
    }

    public static ImageModifier composite(ImageModifier ... modifiers) {
        if (modifiers.length == 0) {
            return EMPTY;
        }
        return new Composite(modifiers);
    }

    public static Function<Image, Image> chain(ImageModifier ... modifiers) {
        return ImageModifier.composite(modifiers)::modify;
    }

    public static ImageModifier optional(boolean condition, ImageModifier modifier) {
        return condition ? modifier : EMPTY;
    }

    public static ImageModifier optional(boolean condition, Supplier<ImageModifier> supplier) {
        return condition ? supplier.get() : EMPTY;
    }

    public static <T> ImageModifier optional(Optional<T> optional, Function<T, ImageModifier> ifPresent) {
        return optional.map(ifPresent).orElse(EMPTY);
    }

    public record Composite(ImageModifier[] modifiers) implements ImageModifier
    {
        @Override
        public Image modify(Image image) {
            for (ImageModifier modifier : this.modifiers) {
                image = modifier.modify(image);
            }
            return image;
        }

        @Override
        public String getIdentifier() {
            return Arrays.stream(this.modifiers).filter(filter -> !filter.equals(EMPTY)).map(ImageModifier::getIdentifier).collect(Collectors.joining("_"));
        }
    }

    public record Instance(String identifier, Function<Image, Image> processingFunction) implements ImageModifier
    {
        @Override
        public Image modify(Image image) {
            return this.processingFunction.apply(image);
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }
    }

    public static interface Resize
    extends ImageModifier {
        public static ImageModifier to(int width, int height) {
            return new Instance("resized-%sx%s".formatted(width, height), image -> new ResizedImage((Image)image, width, height));
        }

        public static ImageModifier to(int size) {
            return Resize.to(size, size);
        }

        public static ImageModifier multiplier(int multiplier) {
            Preconditions.checkArgument((multiplier > 0 ? 1 : 0) != 0, (Object)"multiplier should be larger than 0.");
            return new Instance("resized-%sx".formatted(multiplier), image -> new ResizedImage((Image)image, image.width() * multiplier, image.height() * multiplier));
        }
    }

    public static interface Crop
    extends ImageModifier {
        public static final ImageModifier SQUARE_CENTER = new Instance("crop-square", image -> {
            int smallerSide = Math.min(image.width(), image.height());
            int x = (image.width() - smallerSide) / 2;
            int y = (image.height() - smallerSide) / 2;
            return new CroppedImage((Image)image, new Rect2i(x, y, smallerSide, smallerSide));
        });

        public static ImageModifier factor(double factor) {
            if (factor == 1.0) {
                return EMPTY;
            }
            double clampedFactor = Math.min(1.0, factor);
            return new Instance("crop-factor-" + String.format("%,.4f", clampedFactor), image -> {
                int newWidth = (int)((double)image.width() * clampedFactor);
                int newHeight = (int)((double)image.height() * clampedFactor);
                int x = (image.width() - newWidth) / 2;
                int y = (image.height() - newHeight) / 2;
                return new CroppedImage((Image)image, new Rect2i(x, y, newWidth, newHeight));
            });
        }
    }
}

